
// UsccCreateDialogDlg.cpp: Implementierungsdatei
//

#include "stdafx.h"
#include "UsccCreateDialog.h"
#include "UsccCreateDialogDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CUsccCreateDialogDlg-Dialogfeld




CUsccCreateDialogDlg::CUsccCreateDialogDlg(CWnd* pParent /*=NULL*/)
    : CDialog(CUsccCreateDialogDlg::IDD, pParent)
    , m_pusccControl(NULL)
{
    m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}


CUsccCreateDialogDlg::~CUsccCreateDialogDlg()
{
    delete m_pusccControl;
}


void CUsccCreateDialogDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_USCC_FRAME, m_usccFrame);
    DDX_Control(pDX, IDOK, m_buttonOK);
    DDX_Control(pDX, IDCANCEL, m_buttonCancel);
    DDX_Control(pDX, IDC_PATH, m_staticPath);
    DDX_Control(pDX, IDC_USCC_PATH, m_staticUsccPath);
    DDX_Control(pDX, IDC_BUTTON_PATH, m_buttonPath);
    DDX_Control(pDX, IDC_LANGUAGE, m_staticLanguage);
    DDX_Control(pDX, IDC_COMBO_LANGUAGE, m_comboLanguage);
    DDX_Control(pDX, IDC_BUTTON_LANGUAGE, m_buttonLanguage);
    DDX_CBString(pDX, IDC_COMBO_LANGUAGE, m_strSelectedLanguage);
}

BEGIN_MESSAGE_MAP(CUsccCreateDialogDlg, CDialog)
    ON_MESSAGE(WM_SIZE, OnWmSize)
    ON_MESSAGE(WM_GETMINMAXINFO, OnWmGetMinMaxInfo)
    ON_BN_CLICKED(IDC_BUTTON_PATH, OnBnClickedButtonPath)
    ON_BN_CLICKED(IDC_BUTTON_LANGUAGE, OnBnClickedButtonLanguage)
END_MESSAGE_MAP()


// CUsccCreateDialogDlg-Meldungshandler

BOOL CUsccCreateDialogDlg::OnInitDialog()
{
    CDialog::OnInitDialog();

    // Symbol fr dieses Dialogfeld festlegen. Wird automatisch erledigt
    //  wenn das Hauptfenster der Anwendung kein Dialogfeld ist
    SetIcon(m_hIcon, TRUE);            // Groes Symbol verwenden
    SetIcon(m_hIcon, FALSE);        // Kleines Symbol verwenden

    // TODO: Hier zustzliche Initialisierung einfgen
    GetClientRect(m_rctDialogStart);

    m_usccFrame.GetWindowRect(m_rctUsccFrameStart);
    ScreenToClient(m_rctUsccFrameStart);
    m_rctUsccStart = m_rctUsccFrameStart;
    m_rctUsccStart.DeflateRect(1, 1);

    m_buttonOK.GetWindowRect(m_rctOkStart);
    ScreenToClient(m_rctOkStart);
    m_buttonCancel.GetWindowRect(m_rctCancelStart);
    ScreenToClient(m_rctCancelStart);

    m_staticPath.GetWindowRect(m_rctStaticPathStart);
    ScreenToClient(m_rctStaticPathStart);
    m_staticUsccPath.GetWindowRect(m_rctStaticUsccPathStart);
    ScreenToClient(m_rctStaticUsccPathStart);
    m_buttonPath.GetWindowRect(m_rctButtonPathStart);
    ScreenToClient(m_rctButtonPathStart);

    m_staticLanguage.GetWindowRect(m_rctStaticLanguageStart);
    ScreenToClient(m_rctStaticLanguageStart);
    m_comboLanguage.GetWindowRect(m_rctComboLanguageStart);
    ScreenToClient(m_rctComboLanguageStart);
    m_buttonLanguage.GetWindowRect(m_rctButtonLanguage);
    ScreenToClient(m_rctButtonLanguage);

    m_pusccControl = new CUsccOcx;

    if(!m_pusccControl || !m_pusccControl->Create(L"UsccOcx Control", WS_CHILD|WS_TABSTOP, CRect(0, 0, 200, 200), this, IDC_USCC_OCX)) {

        delete m_pusccControl;

        EndDialog(IDCANCEL);
        return TRUE;
    }

    m_pusccControl->EnableActiveX(1);
    m_pusccControl->SetWindowPos(this,
                                 m_rctUsccStart.left,
                                 m_rctUsccStart.top,
                                 m_rctUsccStart.Width(),
                                 m_rctUsccStart.Height(),
                                 SWP_SHOWWINDOW);

    m_pusccControl->BringWindowToTop();
    m_pusccControl->SetFocus();


    CString strPath = m_pusccControl->usccOcxPath();
    strPath.Replace('/', '\\');
    m_staticUsccPath.SetWindowText(strPath);

    return FALSE;  // TRUE zurckgeben, wenn der Fokus nicht auf ein Steuerelement gesetzt wird
}


LRESULT CUsccCreateDialogDlg::OnWmGetMinMaxInfo(WPARAM wParam, LPARAM lParam)
{
    LPMINMAXINFO pmmi = (LPMINMAXINFO)lParam;
    pmmi->ptMinTrackSize.x = 400;
    pmmi->ptMinTrackSize.y = 400;

    return 0;
}


void CUsccCreateDialogDlg::OnOK()
{
    // Safes actual page
    m_pusccControl->EnableActiveX(0);

    CDialog::OnOK();
}


LRESULT CUsccCreateDialogDlg::OnWmSize(WPARAM wParam, LPARAM lParam)
{
    LRESULT lRet = Default();

    if(!IsWindow(m_pusccControl->m_hWnd)) {
        return lRet;
    }

    Invalidate();

    int cx = (int)LOWORD(lParam);
    int cy = (int)HIWORD(lParam);
    int diffX = cx - m_rctDialogStart.Width();
    int diffY = cy - m_rctDialogStart.Height();

    CRect rctCtrl = m_rctUsccFrameStart;
    rctCtrl.right += diffX;
    rctCtrl.bottom += diffY;
    m_usccFrame.MoveWindow(rctCtrl.left, rctCtrl.top, rctCtrl.Width(), rctCtrl.Height());

    rctCtrl = m_rctUsccStart;
    rctCtrl.right += diffX;
    rctCtrl.bottom += diffY;

    m_pusccControl->MoveWindow(rctCtrl.left, rctCtrl.top, rctCtrl.Width(), rctCtrl.Height());

    rctCtrl = m_rctOkStart;
    rctCtrl.OffsetRect(diffX, diffY);
    m_buttonOK.MoveWindow(rctCtrl.left, rctCtrl.top, rctCtrl.Width(), rctCtrl.Height());

    rctCtrl = m_rctCancelStart;
    rctCtrl.OffsetRect(diffX, diffY);
    m_buttonCancel.MoveWindow(rctCtrl.left, rctCtrl.top, rctCtrl.Width(), rctCtrl.Height());

    rctCtrl = m_rctStaticPathStart;
    rctCtrl.OffsetRect(0, diffY);
    m_staticPath.MoveWindow(rctCtrl.left, rctCtrl.top, rctCtrl.Width(), rctCtrl.Height());

    rctCtrl = m_rctStaticUsccPathStart;
    rctCtrl.OffsetRect(0, diffY);
    rctCtrl.right += diffX;
    m_staticUsccPath.MoveWindow(rctCtrl.left, rctCtrl.top, rctCtrl.Width(), rctCtrl.Height());

    rctCtrl = m_rctButtonPathStart;
    rctCtrl.OffsetRect(diffX, diffY);
    m_buttonPath.MoveWindow(rctCtrl.left, rctCtrl.top, rctCtrl.Width(), rctCtrl.Height());

    rctCtrl = m_rctStaticLanguageStart;
    rctCtrl.OffsetRect(0, diffY);
    m_staticLanguage.MoveWindow(rctCtrl.left, rctCtrl.top, rctCtrl.Width(), rctCtrl.Height());

    rctCtrl = m_rctComboLanguageStart;
    rctCtrl.OffsetRect(0, diffY);
    m_comboLanguage.MoveWindow(rctCtrl.left, rctCtrl.top, rctCtrl.Width(), rctCtrl.Height());

    rctCtrl = m_rctButtonLanguage;
    rctCtrl.OffsetRect(0, diffY);
    m_buttonLanguage.MoveWindow(rctCtrl.left, rctCtrl.top, rctCtrl.Width(), rctCtrl.Height());

    return lRet;
}


void CUsccCreateDialogDlg::OnBnClickedButtonPath()
{
    CString strPath;
    BROWSEINFO bi = { 0 };
    TCHAR chPathBuffer[MAX_PATH + 1] = { 0 };

    bi.hwndOwner = m_hWnd;
    bi.pszDisplayName = chPathBuffer;
    bi.lpszTitle = _T("Select a new usccOcxPath!");
    bi.ulFlags = BIF_RETURNONLYFSDIRS|BIF_USENEWUI;

    PIDLIST_ABSOLUTE pidlFolder = SHBrowseForFolder(&bi);

    if(!pidlFolder)
        return;

    if(lstrlen(bi.pszDisplayName) > 0) {

        m_staticUsccPath.SetWindowText(_T(""));
        UpdateWindow();

        CWaitCursor cw;

        TCHAR chNewPathBuffer[MAX_PATH + 1] = { 0 };

        SHGetPathFromIDList(pidlFolder, chNewPathBuffer);

        strPath = chNewPathBuffer;
        strPath.Replace('\\', '/');

        m_pusccControl->EnableActiveX(0);
        m_pusccControl->setUsccOcxPath(strPath);
        m_pusccControl->EnableActiveX(1);

        // Force resize of UsccOcx control
        CRect rctUscc, rctDialog;
        m_usccFrame.GetWindowRect(rctUscc);
        ScreenToClient(rctUscc);
        rctUscc.DeflateRect(1, 1);
        rctUscc.right--;
        m_pusccControl->SetWindowPos(0,
            rctUscc.left,
            rctUscc.top,
            rctUscc.Width(),
            rctUscc.Height(),
            SWP_SHOWWINDOW);

        GetClientRect(rctDialog);
        PostMessage(WM_SIZE, SIZE_RESTORED, MAKELPARAM(rctDialog.Width(), rctDialog.Height()));


        strPath = m_pusccControl->usccOcxPath();
        strPath.Replace('/', '\\');
        m_staticUsccPath.SetWindowText(strPath);

        GotoDlgCtrl(m_pusccControl);
    }
}


void CUsccCreateDialogDlg::OnBnClickedButtonLanguage()
{
    if(!UpdateData(TRUE))
        return;

    CString strNewLanguage = m_strSelectedLanguage;
    strNewLanguage.Trim();

    if(strNewLanguage.IsEmpty())
        return;

    if(m_pusccControl->SelectLanguage(strNewLanguage)) {
        GotoDlgCtrl(m_pusccControl);
    }
    else {
        GotoDlgCtrl(&m_comboLanguage);
    }
}
